require( "quest/m2_sizzle2/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

max_nuts = 10;
bus_basespeed = 1; -- bux max speed = bus_basespeed * 10

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		
		actor:FaceNow(DIR.E);
		
		scene.CAMERA:JumpToNamedPoint("sizzle2");

		if game:GetLastScene() == "m2_farm" then
			scene:SetCameraFollowActor(scene.CAMERA);
			actor:JumpToNamedPoint("busposd");
			flo_bus = scene:Spawn(flo_bus_spec);
			actor:SetAlpha(0);
			
			move_actor_x(flo_bus, 500);
			move_actor_x(scene.BUS, 500);
			move_actor_x(scene.ERNIE, 500);
			move_actor_x(scene.BUS_WINDOWS, 500);
			move_actor_x(scene.BUS_TYRES, 500);
			scene.BUS_TYRES:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			scene.BUS_TYRES:PlayAnim("DoWalkW");
			
			local dist = 500;
			local speed = -2;
			
			sfx:PlaySFX("audio/sfx/bus_park");
			
			while dist > 0 do
				move_actor_x(flo_bus, speed);
				move_actor_x(scene.BUS, speed);
				move_actor_x(scene.ERNIE, speed);
				move_actor_x(scene.BUS_WINDOWS, speed);
				move_actor_x(scene.BUS_TYRES, speed);
				scene.BUS_TYRES:SetWalkSpeed(-speed);
				dist = dist + speed;
				delay(1);
			end
			
			scene.BUS_TYRES:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			scene.BUS_TYRES:PlayAnim("DoStandW");
			
			flo_bus:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			flo_bus:PlayAnim("LeaveBus");
			wait_anim(flo_bus);
			flo_bus:Expire();
			actor:JumpToNamedPoint("flo_bus");
			actor:SetAlpha(1);
			actor:WalkTo("sizzle2");
			wait_walkto();
			actor:Face(DIR.S);
		else
			scene:SetCameraFollowActor(actor);
			actor:JumpToNamedPoint("intersection");
			actor:WalkTo("sizzle2");
			wait_walkto();
			
			actor:Face(DIR.S);
		end
		
		game:Set("first_time_sizzle2", 1);
		
		scene:SetCameraFollowActor(scene.CAMERA);
		actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	
	on_arrive = function(flo1, flo2)
		convproc("FLO", "quip_flo_general");
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};
--[[
flo_ridebus = function(flo)
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("ernied");
	flo:SetAlpha(1);
	
	wait_walkto();
	
	flo_bus = scene:Spawn(flo_bus_spec);
	flo:SetAlpha(0);
	
	delay(40);
	
	flo_bus:WalkTo("busposc");
	scene.BUS:WalkTo("busposc");
	scene.ERNIE:WalkTo("busposc");
	
	flo:WalkTo("busposc"); --move flo so wait_walkto works
	
	wait_walkto();
	
	goto_scene(flo, "m2_farm", true);
end;
]]
function gotointersection(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("to_intersection");
	delay(150);
	goto_scene(flo, "m2_intersection", true);
end

to_intersection_spec = 
{
	name = "TO_INTERSECTION";
	halo = "to_intersection";
	cursor = "cursor_arrow_w";
	goto_fn = gotointersection;
}

nuts_Table =
{
	{ "nuts1", "bus_hidden_lugnut2"},
	{ "nuts2", "bus_hidden_lugnut1"},
	{ "nuts3", "bus_hidden_lugnut1"},
	{ "nuts4", "bus_hidden_lugnut2"},
	{ "nuts5", "bus_hidden_lugnut1"},
	{ "nuts6", "bus_hidden_lugnut2"},
	{ "nuts7", "bus_hidden_lugnut2"},
	{ "nuts8", "bus_hidden_lugnut1"},
	{ "nuts9", "bus_hidden_lugnut1"},
	{ "nuts10", "bus_hidden_lugnut2"},
};

function wait_for_nut_fly(flo)
	flo:SetMode(MODE.CUTSCENE);
	local nuts_found = game:Get("nuts_found_in_sizzle2");
	coroutine.yield(RESUME.ON_SIGNAL);
	
	--delay(30); -- make it snappy!
	scene.INVENTORY_FLYBACK:Expire();
	delay(2);
	
	if nuts_found == max_nuts then
		BAG_INV:AddInventory(inv_desc_lugnut);
		BAG_INV:RemoveInventory("lugnutcollection");
		BAG_INV:SetInventoryOvertextFlags("lugnut", kHAlignCenter + kVAlignTop);
		local nutText = tostring(nuts_found) .. " / "  .. tostring(max_nuts);
		BAG_INV:SetInventoryOvertext("lugnut", nutText);
		run_super_conversation(flo, "conv_ernie_found_all");
	else
		if nuts_found == 1 then
			BAG_INV:SetInventoryOvertextFlags("lugnutcollection", kHAlignCenter + kVAlignTop);
		end
		
		local nutText = tostring(nuts_found) .. " / "  .. tostring(max_nuts);
		BAG_INV:SetInventoryOvertext("lugnutcollection", nutText);
	end
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function get_nut_spec(_name, _image)
	--lugnutcollection is when you havent collected all the nuts
	--lugnut is when you've got them all
	return
	{
		name = _name;
		halo = "lugnut";
		gfx = { image = _image };
		
		command = function(actor)
			actor.value = _name;
			actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
			actor:JumpToNamedPoint(_name);
			actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		end;
		
		on_arrive = function(flo, nut)
			--flo:FaceActor(nut);
			game:Set("sizzle2_" .. nut.value, 1);
			local nuts_found = game:Get("nuts_found_in_sizzle2");
			nuts_found = nuts_found + 1;
			game:Set("nuts_found_in_sizzle2", nuts_found);
			
			local position = nut:GetScreenPosition();
			local key = inv_desc_lugnutcollection.key;
			
			if nuts_found == 1 then
				BAG_INV:AddInventory(inv_desc_lugnutcollection);
			end
			
			game:SetString("inventory_fly_back_item", key);
			game:Set("inventory_fly_back_loc_X", position.x);
			game:Set("inventory_fly_back_loc_Y", position.y);
			
			-- scroll so the item's SLOT is visible
			BAG_INV:PositionInventoryForVisibility(key);
			
			-- go straight there (don't wait)
			BAG_INV:JumpInventoryToTarget(key);
			
			sfx:PlaySFX("audio/sfx/lugnut_pickup");
			
			-- do the work
			scene:Spawn(inventory_flyback_spec);
			
			nut:Expire();
			scene.FLO:StartProc(wait_for_nut_fly)
		end;	
	}
end;

function spawnnuts(Table)
	for i = 1, max_nuts, 1 do
		if game:Get("sizzle2_" .. Table[i][1]) < 1 then
			scene:Spawn(get_nut_spec(Table[i][1], Table[i][2]));
		end
	end;
end

function bus_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("nuts_found_in_sizzle2") < max_nuts then
		run_super_conversation(flo, "quip_bus_flat");
		if game:Get("clicked_ernie") < 1 then
			game:Set("clicked_ernie", 1);
			run_super_conversation(flo, "conv_ernie_intro");
			add_quest("get_lugnuts");
		end;
	else
		ernie_bus_conv(flo);
	end;
	flo:SetMode(MODE.FOLLOWCLICKS);
end;

local bus_depth = 450;
local bus_start = { x = 0, y = 0 };
local bus_tyres_start = { x = 0+900, y = 0+250 };

bus_spec =
{
	name = "BUS";
	halo = "quest/objects/bus";
	gfx = { anim = "anim/bus/bus" };
	
	command = function(actor)
		actor:JumpToPoint(bus_start);
		actor:SetDepthValue(bus_depth);
		actor:SetWalkSpeed(bus_basespeed);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:FaceNow(DIR.W);
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(bus_conv);
	end;
	
	on_use_inv = function(item, flo, ernie)
		if game:Get("bus_fixed") > 0 then
			if game:Get("bus_paid") < 1 then
				if BAG_INV:CheckInventory("token") then
					flo:StartProc(ernie_bus_use_token);
					return RESPONSE.INV_HANDLED;
				else
					return RESPONSE.INV_UNHANDLED;
				end
			else -- if allready paid
				flo:StartProc(flo_ridebus);
				return RESPONSE.INV_HANDLED;
			end;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
}

bus_tyres_spec =
{
	name = "BUS_TYRES";
	gfx = { anim = "anim/bus/tyres" };
	
	command = function(actor)
		actor:JumpToPoint(bus_tyres_start);
		actor:SetDepthValue(bus_depth-5);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetWalkSpeed(bus_speed);
		actor:FaceNow(DIR.W);
	end;
}

bus_windows_spec = 
{
	name = "BUS_WINDOWS";
	gfx = { image = "window_overlay" };
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:SetWalkSpeed(bus_basespeed);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	end;
}

local ernie_bus_quip = 0;

function ernie_bus_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	local conv;
	
	game:Set("clicked_ernie", 1); -- set this just in case
	
	flo:Face(DIR.E);
	delay(15);
	
	if not quest_added("get_eggs") then
		if ernie_bus_quip == 1 then
			run_super_conversation(flo, "quip_bus_no_go_B");
			ernie_bus_quip = 2
		else
			run_super_conversation(flo, "quip_bus_no_go_A");
			ernie_bus_quip = 1;
		end
	elseif game:Get("bus_paid") < 1 then
		run_super_conversation(flo, "quip_bus_go");
	else
		run_super_conversation(flo, "quip_use_token_B");
		flo:StartProc(flo_ridebus);
		return;
	end
	
	flo:Face(DIR.S);
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end;

function remove_token()
	local token_count = game:Get("token_count");
	
	if token_count < 2 then
		token_count = 0;
		BAG_INV:RemoveInventory("token");
	else
		token_count = token_count - 1;
		BAG_INV:SetInventoryOvertext("token", tostring(token_count));
	end
	
	game:Set("token_count", token_count);
end

function ernie_bus_use_token(flo)
	flo:SetMode(MODE.CUTSCENE);
	game:ClearInvUsage();
	
	if not quest_added("get_eggs") then
		if ernie_bus_quip == 1 then
			run_super_conversation(flo, "quip_bus_no_go_B");
			ernie_bus_quip = 2
		else
			run_super_conversation(flo, "quip_bus_no_go_A");
			ernie_bus_quip = 1;
		end
		flo:SetMode(MODE.FOLLOWCLICKS);
	else
		--if game:Get("mg_chickenchorus_activity_round") > 1 then
		--	run_super_conversation(flo, "quip_reject_token");
		if game:Get("bus_paid") < 1 then
			run_super_conversation(flo, "quip_use_token__A");
			game:Set("bus_paid", 1);
			remove_token();
		else
			run_super_conversation(flo, "quip_use_token_B");
		end
		flo:StartProc(flo_ridebus);
	end
end;

flo_bus_spec =
{
	name = "FLO_BUS";
	gfx = { anim = "anim/flo/bus" };
	
	command = function(actor)
		--actor:JumpToNamedPoint("busposa");
		actor:SetDepthValue(490);
		actor:SetWalkSpeed(bus_basespeed);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:FaceNow(DIR.E);
	end;
}

function flo_ridebus(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("flo_bus");
	wait_walkto();
	flo:SetAlpha(0);
	
	local flo_bus = scene:Spawn(flo_bus_spec);
	flo_bus:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	sfx:PlaySFX("audio/sfx/bus_start");
	flo_bus:PlayAnim("BoardBus");
	wait_anim(flo_bus);
	
	flo_bus:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	flo_bus:PlayAnim("DoStandE");
	
	delay(20);
	
	scene.BUS_TYRES:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.BUS_TYRES:PlayAnim("DoWalkW");
	
	local dist = 1000;
	local speed = -2;
	local accel = -0.05;
	local fadeout = 100;
	
	while dist > 0 do
		move_actor_x(flo_bus, speed);
		move_actor_x(scene.BUS, speed);
		move_actor_x(scene.ERNIE, speed);
		move_actor_x(scene.BUS_WINDOWS, speed);
		move_actor_x(scene.BUS_TYRES, speed);
		scene.BUS_TYRES:SetWalkSpeed(-speed);
		dist = dist + speed;
		speed = speed + accel;
		fadeout = fadeout - 1;
		
		if fadeout == 0 then
			goto_scene(scene.FLO_BUS, "m2_farm");
		end
		delay(1);
	end
end;

function ernie_enterbus(flo)
	flo:SetMode(MODE.CUTSCENE);
	BAG_INV:RemoveInventory("lugnut");
	
	scene.ERNIE:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.ERNIE:PlayAnim("FixTyre1");
	wait_anim(scene.ERNIE);
	
	scene.ERNIE:PlayAnim("FixTyre2");
	wait_anim(scene.ERNIE);
	
	scene.ERNIE:DumpAnimFile("anim/ernie/stand");
	scene.ERNIE:DumpAnimFile("anim/ernie/talk");
	scene.ERNIE:LoadAnimFile("anim/ernie/board_bus2");
	
	scene.ERNIE:PlayAnim("BoardBus1");
	scene.ERNIE:SetDepthMode(DEPTH.DEPTH_FIXED);
	scene.ERNIE:SetDepthValue(501);
	wait_anim(scene.ERNIE);
	
	scene.ERNIE:PlayAnim("BoardBus2");
	wait_anim(scene.ERNIE);

	scene.ERNIE:SetDepthMode(DEPTH.DEPTH_BY_Y);
	scene.ERNIE:SetDepthValue(scene.ERNIE:GetPosition().y);
	scene.ERNIE:PlayAnim("BoardBus3");
	wait_anim(scene.ERNIE);
	
	scene.ERNIE:SetAlpha(0);
	delay(60);
	scene.ERNIE:SetAlpha(1);
	
	scene.ERNIE:PlayAnim("BoardBus4");
	wait_anim(scene.ERNIE)
	
	scene.ERNIE:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.ERNIE:PlayAnim("DoStandW");
	scene.ERNIE:LoadZone("quest/objects/ernie_bus");
	scene.ERNIE:ModifySaySpec(ernie_bus_text_spec);
	scene.ERNIE:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	
	complete_quest("get_lugnuts");
	wait_subscene();
	
	game:Set("clicked_ernie", 1); -- set this just in case
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end;

function ernie_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	flo:Face(DIR.E);
	delay(15);
	
	if game:Get("clicked_ernie") < 1 then
		game:Set("clicked_ernie", 1);
		run_super_conversation(flo, "conv_ernie_intro");
		add_quest("get_lugnuts");
		wait_subscene();
		flo:SetMode(MODE.FOLLOWCLICKS);
	elseif game:Get("nuts_found_in_sizzle2") <= 0 then
		run_super_conversation(flo, "conv_ernie_found_none");
		flo:SetMode(MODE.FOLLOWCLICKS);
	elseif game:Get("nuts_found_in_sizzle2") >= 1 and game:Get("nuts_found_in_sizzle2") < max_nuts then
		if game:Get("ernie_found_some_conv") <= 0 then
			run_super_conversation(flo, "conv_ernie_found_some");
			game:Set("ernie_found_some_conv", 1);
		else
			run_super_conversation(flo, "conv_ernie_chat");
		end
		flo:SetMode(MODE.FOLLOWCLICKS);
	elseif BAG_INV:CheckInventory("lugnut") then
		--game:Set("bus_fixed", 1);		
		--ernie_enterbus(flo);
		run_super_conversation(flo, "conv_ernie_found_all");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
	
	flo:Face(DIR.S);
end;

ernie_anim_table = 
{
	"anim/ernie/board_bus1",
	"anim/ernie/fix_tyre1",
	"anim/ernie/fix_tyre2",
}

ernie_spec = 
{
	name = "ERNIE";
	anim = ernie_anim_table;
	
	command = function(actor)
		-- enable ground-based 
		prepare_actor_text(actor, ernie_text_spec);
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(bus_basespeed);
		actor:JumpToNamedPoint("erniea");
		actor:FaceNow(DIR.W);
		
		if game:Get("bus_fixed") >= 1 then
			actor:LoadAnimFile("anim/ernie/board_bus2");
			actor:LoadZone("quest/objects/ernie_bus");
			scene.ERNIE:ModifySaySpec(ernie_bus_text_spec);
			scene.ERNIE:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH)
		else
			actor:LoadAnimFile("anim/ernie/stand");
			actor:LoadAnimFile("anim/ernie/talk");
			actor:LoadZone("quest/objects/erniew");
		end;
		
		actor:PlayAnim("DoStandW");
	end;
	
	on_arrive = function(flo, ernie)
		if game:Get("bus_fixed") > 0 then
			flo:StartProc(ernie_bus_conv);
		else
			flo:StartProc(ernie_conv);
		end
	end;
	
	on_use_inv = function(item, flo, ernie)
		flo:FaceActor(ernie);
		if item == "token" then
			if game:Get("bus_fixed") > 0 then
				if game:Get("bus_paid") < 1 then
					flo:StartProc(ernie_bus_use_token);
				else -- if already paid
					flo:StartProc(flo_ridebus);
				end;
			else
				convproc("FLO", "quip_bus_flat");
			end
			return RESPONSE.INV_HANDLED;
		else
			if item == "lugnut" then
				game:Set("bus_fixed", 1);			
				flo:StartProc(ernie_enterbus);
				return RESPONSE.INV_HANDLED;
			else
				return RESPONSE.INV_UNHANDLED;
			end
		end
	end;
};

bus_stop_spec = 
{
	name = "bus_stop";
	halo = "bus_stop";
	
	command = function(actor)
		actor:SetDepthValue(5);
	end;
	
	on_arrive = function(flo, ernie)
		if game:Get("module_progress") < 3 then
			convproc("FLO", "quip_bus_stop");
		end
	end;
};

camera_spec = 
{
	name = "CAMERA";
	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetWalkSpeed(6);
		
		actor:JumpToNamedPoint("intersection");
	end;
};

bus_sign_spec = 
{
	name = "BUS_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/itc_kabel_std_ultra.mvec",
			color = { a = 1, r = 0.93, g = 0.94, b = 0.86 },
			outline_size = 0,
			lineheight = 34,
			linepadding = 2,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_bus_sign");
		actor:StopWalking();
		actor:SetPolygon({x=981,y=212}, {x=1063,y=212}, {x=981,y=252}, {x=1063,y=250});
		actor:TextToImage(10, 0);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_streets2.ogg", true);
		sfx:PlaySFX("audio/sfx/ambient_mod1.ogg", true);
		scene:SetRoomScale(300, 550, 0.6, 0.8);	--topline, bottomline, topscale, bottomscale
		
		local no_fade = game:GetLastScene() == "m2_intersection";
		fade_scene_up(false, no_fade);
		
		if IsCheatMode() then
			--BAG_INV:AddInventory(inv_desc_lugnut);
			--BAG_INV:AddInventory(inv_desc_token);
			--game:Set("bus_fixed", 1);
			-- testing data
		end
		
		spawn_nav_arrow(to_intersection_spec);
		
		scene:SetCameraFollowActor(scene.CAMERA);		-- Attach the camera to follow "CAMERA" actor
		scene:SetCameraMargin { x = 400, y = 300 };
		
		if game:Get("beads_found_in_sizzle2") < max_nuts then
			spawnnuts(nuts_Table);
		end;
		
		if game:Get("module_progress") < 3 then
			scene:Spawn(ernie_spec);
			scene:Spawn(bus_spec);
			scene:Spawn(bus_windows_spec);
			scene:Spawn(bus_tyres_spec);
		end
		
		spawn_simple_hotspot("end_of_street", 5);
		
		game:SetString("map_position", "m2_sizzle2");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		{ "mask_fence1", 380},
		{ "mask_fence2", 380},
		{ "bus_stop_sign", 380},
		--{ "trees1", 360 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist =
	{ 
		camera_spec,
		scene_setup,
		
		bus_stop_spec,
		bus_sign_spec,
		
		flo_spec, -- the main actor
	};
};